/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts.core_assets.skills.active.combat_arts;

import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.forixaim.battle_arts.core_assets.animations.BattleAnimations;
import net.forixaim.battle_arts.core_assets.capabilities.styles.ImperatriceLumiereStyles;
import net.forixaim.battle_arts.core_assets.skills.BattleArtsDataKeys;
import net.forixaim.battle_arts.core_assets.skills.active.combat_arts.CombatArt;
import net.forixaim.battle_arts.initialization.registry.SkillRegistry;
import net.forixaim.bs_api.battle_arts_skills.BattleArtsSkillSlots;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ImperatriceSpecials
extends CombatArt {
    private static final UUID EVENT_UUID = UUID.fromString("a4deb3a3-2eb2-4e3b-8204-265e95cc4eaf");
    private static final AnimationProvider<AttackAnimation> provider = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_INCANDESCENT_FIREWORK.get();
    private static final AnimationProvider<AttackAnimation> INFERNO_ASTROLABE = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_INFERNO_ASTROLABE;

    public ImperatriceSpecials(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FriendlyByteBuf gatherArguments(LocalPlayerPatch executer, ControllEngine controllEngine) {
        Input input = ((LocalPlayer)executer.getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)executer.getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92085_) ? 1 : 0;
        int backward = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92087_) ? -1 : 0;
        int left = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92086_) ? 1 : 0;
        int right = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92088_) ? -1 : 0;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(forward);
        buf.writeInt(backward);
        buf.writeInt(left);
        buf.writeInt(right);
        return buf;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        int forward = args.readInt();
        int backward = args.readInt();
        int left = args.readInt();
        int right = args.readInt();
        int vertic = forward + backward;
        int horizon = left + right;
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(Integer.compare(vertic, 0));
        packet.getBuffer().writeInt(Integer.compare(horizon, 0));
        return packet;
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            if (event.getAnimation().equals((Object)provider.get()) || event.getAnimation().equals((Object)INFERNO_ASTROLABE.get())) {
                ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.SPECIAL_EXECUTING.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        super.onInitiate(container);
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    @Override
    public boolean canExecute(PlayerPatch<?> executer) {
        return executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).hasSkill(SkillRegistry.IMPERATRICE_LUMIERE) && (Boolean)executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.SPECIAL_EXECUTING.get()) == false && executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get()) && (Boolean)executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get()) == false && (Boolean)executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get()) == false;
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executor, FriendlyByteBuf args) {
        int forwardBack = args.readInt();
        int leftRight = args.readInt();
        executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.SPECIAL_EXECUTING.get(), (Object)true, (ServerPlayer)executor.getOriginal());
        if (forwardBack == 1 && executor.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)executor) == ImperatriceLumiereStyles.IMPERATRICE_SWORD) {
            executor.playAnimationSynchronized(INFERNO_ASTROLABE.get(), 0.0f);
        } else {
            executor.playAnimationSynchronized(provider.get(), 0.0f);
        }
    }
}

